//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.12

import wesual.Ui 1.0

Item {
    id : loadIndicator

    property alias color   : effect.color
    property bool  loading : false

    implicitWidth  : 64
    implicitHeight : 64
    opacity        : 0

    states : State {
        name : "loading"
        when : loading

        PropertyChanges {
            target  : loadIndicator
            opacity : 1
        }
        PropertyChanges {
            target  : animation
            running : true
        }
    }

    transitions : [
        Transition {
            to : "loading"
            SequentialAnimation {
                PauseAnimation { duration : 300 }
                PropertyAction { property : "running" }
                NumberAnimation {
                    property : "opacity"
                }
            }
        },
        Transition {
            from : "loading"
            SequentialAnimation {
                NumberAnimation {
                    property : "opacity"
                }
                PropertyAction { property : "running" }
            }
        }
    ]

    RotationAnimation {
        id : animation

        target   : effect
        from     : 0.0
        to       : 360.0
        duration : 1000
        running  : false
        loops    : Animation.Infinite
    }

    ShaderEffect {
        id : effect

        property color color : UiColors.getColor(UiColors.ButtonNormalBlue)

        readonly property Image mask : maskSrc

        Image {
            id : maskSrc

            visible : false
            source  : "qrc:/ui/images/loadindicator.png"
            sourceSize {
                width : loadIndicator.width
                height : loadIndicator.height
            }
        }

        anchors.fill : parent

        vertexShader : "
            attribute mediump vec4 qt_Vertex;
            attribute mediump vec2 qt_MultiTexCoord0;

            uniform mediump mat4 qt_Matrix;
            varying mediump vec2 v_TexCoord;

            void main() {
                gl_Position = qt_Matrix * qt_Vertex;
                v_TexCoord  = qt_MultiTexCoord0;
            }"

        fragmentShader : "
            uniform lowp float qt_Opacity;

            uniform sampler2D mask;
            uniform lowp vec4 color;

            varying mediump vec2 v_TexCoord;

            void main() {
                lowp float mask = texture2D(mask, v_TexCoord).r;
                gl_FragColor = color * mask * qt_Opacity;
            }"
    }
}
